<?php
// Simplified Contact Form Handler for Velaxio Digital Solutions
// Minimal version to avoid server errors

// Set content type
header('Content-Type: application/json');

// Enable CORS
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

// Handle preflight request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

// Only allow POST requests
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Method not allowed']);
    exit();
}

// Simple configuration
$to_email = 'hello@velaxio.com';
$from_email = 'noreply@velaxio.com';

// Get form data
$name = isset($_POST['name']) ? trim($_POST['name']) : '';
$email = isset($_POST['email']) ? trim($_POST['email']) : '';
$phone = isset($_POST['phone']) ? trim($_POST['phone']) : '';
$service = isset($_POST['service']) ? trim($_POST['service']) : '';
$message = isset($_POST['message']) ? trim($_POST['message']) : '';

// Basic validation
if (empty($name) || empty($email) || empty($service) || empty($message)) {
    echo json_encode(['success' => false, 'message' => 'All required fields must be filled']);
    exit();
}

if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
    echo json_encode(['success' => false, 'message' => 'Invalid email address']);
    exit();
}

// Prepare email content
$subject = '[Velaxio Contact] New Message from ' . $name;
$email_message = "
New contact form submission from Velaxio website:

Name: $name
Email: $email
Phone: " . ($phone ? $phone : 'Not provided') . "
Service: $service

Message:
$message

---
Sent from Velaxio Digital Solutions contact form
";

// Email headers
$headers = "From: $from_email\r\n";
$headers .= "Reply-To: $email\r\n";
$headers .= "X-Mailer: PHP/" . phpversion() . "\r\n";

// Send email
$mail_sent = mail($to_email, $subject, $email_message, $headers);

if ($mail_sent) {
    echo json_encode(['success' => true, 'message' => 'Message sent successfully! We\'ll get back to you within 24 hours.']);
} else {
    echo json_encode(['success' => false, 'message' => 'Failed to send message. Please try again or contact us directly.']);
}
?>
