<?php
// Simple PHP test file for Velaxio Digital Solutions
// This file tests if PHP is working correctly

header('Content-Type: text/html; charset=UTF-8');

echo "<!DOCTYPE html>";
echo "<html lang='en'>";
echo "<head>";
echo "<meta charset='UTF-8'>";
echo "<meta name='viewport' content='width=device-width, initial-scale=1.0'>";
echo "<title>PHP Test - Velaxio Digital Solutions</title>";
echo "<style>";
echo "body { font-family: Arial, sans-serif; margin: 40px; background: #f5f5f5; }";
echo ".container { max-width: 600px; margin: 0 auto; background: white; padding: 30px; border-radius: 10px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); }";
echo ".success { color: #4CAF50; font-weight: bold; }";
echo ".info { color: #2196F3; }";
echo ".error { color: #f44336; }";
echo "</style>";
echo "</head>";
echo "<body>";

echo "<div class='container'>";
echo "<h1>🚀 Velaxio Digital Solutions - PHP Test</h1>";

// Test basic PHP functionality
echo "<h2>PHP Status</h2>";
echo "<p class='success'>✅ PHP is working correctly!</p>";
echo "<p class='info'>PHP Version: " . phpversion() . "</p>";

// Test mail function
echo "<h2>Mail Function Test</h2>";
if (function_exists('mail')) {
    echo "<p class='success'>✅ Mail function is available</p>";
} else {
    echo "<p class='error'>❌ Mail function is not available</p>";
}

// Test file permissions
echo "<h2>File Permissions Test</h2>";
if (is_writable('.')) {
    echo "<p class='success'>✅ Directory is writable</p>";
} else {
    echo "<p class='error'>❌ Directory is not writable</p>";
}

// Test server info
echo "<h2>Server Information</h2>";
echo "<p class='info'>Server Software: " . $_SERVER['SERVER_SOFTWARE'] . "</p>";
echo "<p class='info'>Document Root: " . $_SERVER['DOCUMENT_ROOT'] . "</p>";
echo "<p class='info'>Current Directory: " . getcwd() . "</p>";

// Test contact form
echo "<h2>Contact Form Test</h2>";
echo "<form method='POST' action='contact-simple.php'>";
echo "<p><input type='text' name='name' placeholder='Your Name' required style='width: 100%; padding: 10px; margin: 5px 0;'></p>";
echo "<p><input type='email' name='email' placeholder='Your Email' required style='width: 100%; padding: 10px; margin: 5px 0;'></p>";
echo "<p><input type='tel' name='phone' placeholder='Your Phone' style='width: 100%; padding: 10px; margin: 5px 0;'></p>";
echo "<p><select name='service' required style='width: 100%; padding: 10px; margin: 5px 0;'>";
echo "<option value=''>Select Service</option>";
echo "<option value='digital-marketing'>Digital Marketing</option>";
echo "<option value='ui-ux-design'>UI/UX Design</option>";
echo "<option value='web-hosting'>Web Hosting</option>";
echo "<option value='end-to-end-support'>End-to-End Support</option>";
echo "</select></p>";
echo "<p><textarea name='message' placeholder='Your Message' required rows='4' style='width: 100%; padding: 10px; margin: 5px 0;'></textarea></p>";
echo "<p><button type='submit' style='background: #00d4ff; color: white; padding: 12px 24px; border: none; border-radius: 5px; cursor: pointer;'>Send Test Message</button></p>";
echo "</form>";

echo "<h2>Next Steps</h2>";
echo "<ol>";
echo "<li>If PHP is working, try accessing your main website</li>";
echo "<li>If mail function works, test the contact form</li>";
echo "<li>Check file permissions if there are issues</li>";
echo "<li>Contact your hosting provider if problems persist</li>";
echo "</ol>";

echo "<p><a href='index.html' style='color: #00d4ff; text-decoration: none;'>← Back to Velaxio Website</a></p>";

echo "</div>";
echo "</body>";
echo "</html>";
?>
